/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.util;

import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.tileentity.TravelersBackpackBlockEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3419;

public class BackpackUtils {
    public static void onPlayerDeath(class_1937 world, class_1657 player, class_1799 stack) {
        if (TravelersBackpackConfig.backpackDeathPlace) {
            if (TravelersBackpackConfig.backpackForceDeathPlace) {
                if (!BackpackUtils.forcePlace(world, player, stack)) {
                    ComponentUtils.getComponent(player).removeWearable();
                    if (TravelersBackpackConfig.enableBackpackCoordsMessage) {
                        String translation = new class_2588("information.travelersbackpack.backpack_drop").getString();
                        player.method_7353((class_2561)new class_2585(translation + " X: " + player.method_19538().method_10216() + " Y: " + player.method_19538().method_10214() + " Z: " + player.method_19538().method_10215()), false);
                        System.out.println(translation + " X: " + player.method_19538().method_10216() + " Y: " + player.method_19538().method_10214() + " Z: " + player.method_19538().method_10215());
                    }
                }
            } else if (!BackpackUtils.tryPlace(world, player, stack)) {
                player.method_5699(stack, 1.0f);
                ComponentUtils.getComponent(player).removeWearable();
                if (TravelersBackpackConfig.enableBackpackCoordsMessage) {
                    String translation = new class_2588("information.travelersbackpack.backpack_drop").getString();
                    player.method_7353((class_2561)new class_2585(translation + " X: " + player.method_19538().method_10216() + " Y: " + player.method_19538().method_10214() + " Z: " + player.method_19538().method_10215()), false);
                    System.out.println(translation + " X: " + player.method_19538().method_10216() + " Y: " + player.method_19538().method_10214() + " Z: " + player.method_19538().method_10215());
                }
            }
        } else {
            player.method_5699(stack, 1.0f);
            if (TravelersBackpackConfig.enableBackpackCoordsMessage) {
                String translation = new class_2588("information.travelersbackpack.backpack_drop").getString();
                player.method_7353((class_2561)new class_2585(translation + " X: " + player.method_19538().method_10216() + " Y: " + player.method_19538().method_10214() + " Z: " + player.method_19538().method_10215()), false);
                System.out.println(translation + " X: " + player.method_19538().method_10216() + " Y: " + player.method_19538().method_10214() + " Z: " + player.method_19538().method_10215());
            }
            ComponentUtils.getComponent(player).removeWearable();
        }
    }

    public static class_2338 findBlock3D(class_1937 world, int x, int y, int z, class_2248 block, int hRange, int vRange) {
        for (int i = y - vRange; i <= y + vRange; ++i) {
            for (int j = x - hRange; j <= x + hRange; ++j) {
                for (int k = z - hRange; k <= z + hRange; ++k) {
                    if (world.method_8320(new class_2338(j, i, k)).method_26204() != block) continue;
                    return new class_2338(j, i, k);
                }
            }
        }
        return null;
    }

    private static boolean forcePlace(class_1937 world, class_1657 player, class_1799 stack) {
        class_2338 targetPos;
        if (stack.method_7969() == null) {
            stack.method_7980(new class_2487());
        }
        class_2248 block = class_2248.method_9503((class_1792)stack.method_7909());
        class_2338 playerPos = player.method_24515();
        int y = playerPos.method_10264();
        if (y <= world.method_8597().method_29959() || y >= world.method_31605()) {
            for (int i = 1; i < world.method_31605(); ++i) {
                class_2338 pos = new class_2338(playerPos.method_10263(), i, playerPos.method_10260());
                if (!world.method_8320(pos).method_26215() && !(world.method_8320(pos).method_26214((class_1922)world, pos) > -1.0f)) continue;
                y = i;
                break;
            }
        }
        if (world.method_8320(targetPos = new class_2338(playerPos.method_10263(), y, playerPos.method_10260())).method_26214((class_1922)world, targetPos) > -1.0f) {
            while (world.method_8321(targetPos) != null) {
                targetPos = targetPos.method_10084();
            }
            if (!world.method_8501(targetPos, block.method_9564())) {
                return false;
            }
            if (TravelersBackpackConfig.enableBackpackCoordsMessage) {
                String translation = new class_2588("information.travelersbackpack.backpack_coords").getString();
                player.method_7353((class_2561)new class_2585(translation + " X: " + playerPos.method_10263() + " Y: " + y + " Z: " + playerPos.method_10260()), false);
            }
            world.method_8465(player, (double)playerPos.method_10263(), (double)y, (double)playerPos.method_10260(), block.method_9564().method_26231().method_10598(), class_3419.field_15245, 0.5f, 1.0f);
            ((TravelersBackpackBlockEntity)world.method_8321(targetPos)).readAllData(stack.method_7969());
            if (ComponentUtils.isWearingBackpack(player)) {
                ComponentUtils.getComponent(player).setWearable(class_1799.field_8037);
            }
            return true;
        }
        return false;
    }

    private static boolean tryPlace(class_1937 world, class_1657 player, class_1799 stack) {
        int[] positions;
        int X = (int)player.method_23317();
        int Z = (int)player.method_23321();
        for (int Y : positions = new int[]{0, -1, 1, -2, 2, -3, 3, -4, 4, -5, 5, -6, 6}) {
            class_2338 spawn = BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, world, X, Z, new class_2338(X, (int)player.method_23318() + Y, Z), 12, true, 1, (byte)0, false);
            if (spawn == null) continue;
            return BackpackUtils.placeBackpack(stack, player, world, spawn.method_10263(), spawn.method_10264(), spawn.method_10260(), class_2350.field_11036);
        }
        return false;
    }

    public static boolean placeBackpack(class_1799 stack, class_1657 player, class_1937 world, int x, int y, int z, class_2350 facing) {
        if (stack.method_7969() == null) {
            stack.method_7980(new class_2487());
        }
        class_2248 block = class_2248.method_9503((class_1792)stack.method_7909());
        if (y <= world.method_8597().method_29959() || y >= world.method_31605()) {
            return false;
        }
        class_2338 targetPos = new class_2338(x, y, z);
        if (world.method_8320(targetPos).method_26207().method_15800() && !world.method_8320(targetPos).method_26207().method_15799()) {
            if (!world.method_8501(targetPos, block.method_9564())) {
                return false;
            }
            if (TravelersBackpackConfig.enableBackpackCoordsMessage) {
                String translation = new class_2588("information.travelersbackpack.backpack_coords").getString();
                player.method_7353((class_2561)new class_2585(translation + " X: " + x + " Y: " + y + " Z: " + z), false);
            }
            world.method_8465(player, (double)x, (double)y, (double)z, block.method_9564().method_26231().method_10598(), class_3419.field_15245, 0.5f, 1.0f);
            ((TravelersBackpackBlockEntity)world.method_8321(targetPos)).readAllData(stack.method_7969());
            if (stack.method_7938()) {
                ((TravelersBackpackBlockEntity)world.method_8321(targetPos)).setCustomName(stack.method_7964());
            }
            if (ComponentUtils.isWearingBackpack(player)) {
                ComponentUtils.getComponent(player).setWearable(class_1799.field_8037);
            }
            return true;
        }
        return false;
    }

    public static class_2338 getNearestEmptyChunkCoordinatesSpiral(class_1657 player, class_1937 world, int origX, int origZ, class_2338 pos, int radius, boolean except, int steps, byte pass, boolean type) {
        int j;
        int i;
        if (steps >= radius) {
            return null;
        }
        if (steps % 2 == 0) {
            if (pass == 0) {
                for (i = pos.method_10263(); i <= pos.method_10263() + steps; ++i) {
                    class_2338 blockPos;
                    class_2338 class_23382 = blockPos = type ? BackpackUtils.checkCoordsForPlayer(player, world, origX, origZ, pos, except) : BackpackUtils.checkCoordsForBackpack(player, world, origX, origZ, pos, except);
                    if (blockPos == null) continue;
                    return blockPos;
                }
                pass = (byte)(pass + 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, world, origX, origZ, new class_2338(i, pos.method_10264(), j), radius, except, steps, pass, type);
            }
            if (pass == 1) {
                for (j = pos.method_10260(); j >= pos.method_10260() - steps; --j) {
                    class_2338 blockPos;
                    class_2338 class_23383 = blockPos = type ? BackpackUtils.checkCoordsForPlayer(player, world, origX, origZ, pos, except) : BackpackUtils.checkCoordsForBackpack(player, world, origX, origZ, pos, except);
                    if (blockPos == null) continue;
                    return blockPos;
                }
                pass = (byte)(pass - 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, world, origX, origZ, new class_2338(i, pos.method_10264(), j), radius, except, ++steps, pass, type);
            }
        }
        if (steps % 2 == 1) {
            if (pass == 0) {
                while (i >= pos.method_10263() - steps) {
                    class_2338 blockPos;
                    class_2338 class_23384 = blockPos = type ? BackpackUtils.checkCoordsForPlayer(player, world, origX, origZ, pos, except) : BackpackUtils.checkCoordsForBackpack(player, world, origX, origZ, pos, except);
                    if (blockPos != null) {
                        return blockPos;
                    }
                    --i;
                }
                pass = (byte)(pass + 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, world, origX, origZ, new class_2338(i, pos.method_10264(), j), radius, except, steps, pass, type);
            }
            if (pass == 1) {
                while (j <= pos.method_10260() + steps) {
                    class_2338 blockPos;
                    class_2338 class_23385 = blockPos = type ? BackpackUtils.checkCoordsForPlayer(player, world, origX, origZ, pos, except) : BackpackUtils.checkCoordsForBackpack(player, world, origX, origZ, pos, except);
                    if (blockPos != null) {
                        return blockPos;
                    }
                    ++j;
                }
                pass = (byte)(pass - 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, world, origX, origZ, new class_2338(i, pos.method_10264(), j), radius, except, ++steps, pass, type);
            }
        }
        return null;
    }

    private static class_2338 checkCoordsForBackpack(class_1657 player, class_1937 world, int origX, int origZ, class_2338 pos, boolean except) {
        if (except && world.method_8515(pos.method_10093(class_2350.field_11033), (class_1297)player) && world.method_22347(pos) && !BackpackUtils.areCoordinatesTheSame(new class_2338(origX, pos.method_10264(), origZ), pos)) {
            return pos;
        }
        if (!except && world.method_8515(pos.method_10093(class_2350.field_11033), (class_1297)player) && world.method_22347(pos)) {
            return pos;
        }
        return null;
    }

    private static class_2338 checkCoordsForPlayer(class_1657 player, class_1937 world, int origX, int origZ, class_2338 pos, boolean except) {
        if (except && world.method_8515(pos.method_10093(class_2350.field_11033), (class_1297)player) && world.method_22347(pos) && world.method_22347(pos.method_10093(class_2350.field_11036)) && !BackpackUtils.areCoordinatesTheSame2D(origX, origZ, pos.method_10263(), pos.method_10260())) {
            return pos;
        }
        if (!except && world.method_8515(pos.method_10093(class_2350.field_11033), (class_1297)player) && world.method_22347(pos) && world.method_22347(pos.method_10093(class_2350.field_11036))) {
            return pos;
        }
        return null;
    }

    private static boolean areCoordinatesTheSame(class_2338 pos1, class_2338 pos2) {
        return pos1 == pos2;
    }

    private static boolean areCoordinatesTheSame2D(int X1, int Z1, int X2, int Z2) {
        return X1 == X2 && Z1 == Z2;
    }
}

